// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/services/network/public/interfaces/http_connection.mojom
//

package org.chromium.mojom.mojo;

class HttpConnectionDelegate_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<HttpConnectionDelegate, HttpConnectionDelegate.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<HttpConnectionDelegate, HttpConnectionDelegate.Proxy>() {
    
        public String getName() {
            return "mojo::HttpConnectionDelegate";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, HttpConnectionDelegate impl) {
            return new Stub(core, impl);
        }
    
        public HttpConnectionDelegate[] buildArray(int size) {
          return new HttpConnectionDelegate[size];
        }
    };

    private static final int ON_RECEIVED_REQUEST_ORDINAL = 0;
    private static final int ON_RECEIVED_WEB_SOCKET_REQUEST_ORDINAL = 1;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements HttpConnectionDelegate.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void onReceivedRequest(HttpRequest request, OnReceivedRequestResponse callback) {
            HttpConnectionDelegateOnReceivedRequestParams _message = new HttpConnectionDelegateOnReceivedRequestParams();
            _message.request = request;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    ON_RECEIVED_REQUEST_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new HttpConnectionDelegateOnReceivedRequestResponseParamsForwardToCallback(callback));
        }

        @Override
        public void onReceivedWebSocketRequest(HttpRequest request, OnReceivedWebSocketRequestResponse callback) {
            HttpConnectionDelegateOnReceivedWebSocketRequestParams _message = new HttpConnectionDelegateOnReceivedWebSocketRequestParams();
            _message.request = request;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    ON_RECEIVED_WEB_SOCKET_REQUEST_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsForwardToCallback(callback));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<HttpConnectionDelegate> {

        Stub(org.chromium.mojo.system.Core core, HttpConnectionDelegate impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                HttpConnectionDelegate_Internal.MANAGER, messageWithHeader);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), HttpConnectionDelegate_Internal.MANAGER, messageWithHeader, receiver);
                    case ON_RECEIVED_REQUEST_ORDINAL: {
                        HttpConnectionDelegateOnReceivedRequestParams data =
                                HttpConnectionDelegateOnReceivedRequestParams.deserialize(messageWithHeader.getPayload());
                        getImpl().onReceivedRequest(data.request, new HttpConnectionDelegateOnReceivedRequestResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case ON_RECEIVED_WEB_SOCKET_REQUEST_ORDINAL: {
                        HttpConnectionDelegateOnReceivedWebSocketRequestParams data =
                                HttpConnectionDelegateOnReceivedWebSocketRequestParams.deserialize(messageWithHeader.getPayload());
                        getImpl().onReceivedWebSocketRequest(data.request, new HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class HttpConnectionDelegateOnReceivedRequestParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public HttpRequest request;
    
        private HttpConnectionDelegateOnReceivedRequestParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public HttpConnectionDelegateOnReceivedRequestParams() {
            this(0);
        }
    
        public static HttpConnectionDelegateOnReceivedRequestParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static HttpConnectionDelegateOnReceivedRequestParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionDelegateOnReceivedRequestParams result = new HttpConnectionDelegateOnReceivedRequestParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.request = HttpRequest.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(request, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            HttpConnectionDelegateOnReceivedRequestParams other = (HttpConnectionDelegateOnReceivedRequestParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.request, other.request))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(request);
            return result;
        }
    }

    static final class HttpConnectionDelegateOnReceivedRequestResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public HttpResponse response;
    
        private HttpConnectionDelegateOnReceivedRequestResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public HttpConnectionDelegateOnReceivedRequestResponseParams() {
            this(0);
        }
    
        public static HttpConnectionDelegateOnReceivedRequestResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static HttpConnectionDelegateOnReceivedRequestResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionDelegateOnReceivedRequestResponseParams result = new HttpConnectionDelegateOnReceivedRequestResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.response = HttpResponse.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(response, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            HttpConnectionDelegateOnReceivedRequestResponseParams other = (HttpConnectionDelegateOnReceivedRequestResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.response, other.response))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(response);
            return result;
        }
    }

    static class HttpConnectionDelegateOnReceivedRequestResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final HttpConnectionDelegate.OnReceivedRequestResponse mCallback;

        HttpConnectionDelegateOnReceivedRequestResponseParamsForwardToCallback(HttpConnectionDelegate.OnReceivedRequestResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_RECEIVED_REQUEST_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                HttpConnectionDelegateOnReceivedRequestResponseParams response = HttpConnectionDelegateOnReceivedRequestResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.response);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class HttpConnectionDelegateOnReceivedRequestResponseParamsProxyToResponder implements HttpConnectionDelegate.OnReceivedRequestResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        HttpConnectionDelegateOnReceivedRequestResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(HttpResponse response) {
            HttpConnectionDelegateOnReceivedRequestResponseParams _response = new HttpConnectionDelegateOnReceivedRequestResponseParams();
            _response.response = response;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    ON_RECEIVED_REQUEST_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class HttpConnectionDelegateOnReceivedWebSocketRequestParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public HttpRequest request;
    
        private HttpConnectionDelegateOnReceivedWebSocketRequestParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public HttpConnectionDelegateOnReceivedWebSocketRequestParams() {
            this(0);
        }
    
        public static HttpConnectionDelegateOnReceivedWebSocketRequestParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static HttpConnectionDelegateOnReceivedWebSocketRequestParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionDelegateOnReceivedWebSocketRequestParams result = new HttpConnectionDelegateOnReceivedWebSocketRequestParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.request = HttpRequest.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(request, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            HttpConnectionDelegateOnReceivedWebSocketRequestParams other = (HttpConnectionDelegateOnReceivedWebSocketRequestParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.request, other.request))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(request);
            return result;
        }
    }

    static final class HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public org.chromium.mojo.bindings.InterfaceRequest<WebSocket> webSocket;
        public org.chromium.mojo.system.DataPipe.ConsumerHandle sendStream;
        public WebSocketClient client;
    
        private HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams(int version) {
            super(STRUCT_SIZE, version);
            sendStream = org.chromium.mojo.system.InvalidHandle.INSTANCE;
        }
    
        public HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams() {
            this(0);
        }
    
        public static HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams result = new HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.webSocket = decoder0.readInterfaceRequest(8, true);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sendStream = decoder0.readConsumerHandle(12, true);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.client = decoder0.readServiceInterface(16, true, WebSocketClient.MANAGER);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(webSocket, 8, true);
            encoder0.encode(sendStream, 12, true);
            encoder0.encode(client, 16, true, WebSocketClient.MANAGER);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams other = (HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.webSocket, other.webSocket))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sendStream, other.sendStream))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.client, other.client))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(webSocket);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sendStream);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(client);
            return result;
        }
    }

    static class HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final HttpConnectionDelegate.OnReceivedWebSocketRequestResponse mCallback;

        HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsForwardToCallback(HttpConnectionDelegate.OnReceivedWebSocketRequestResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_RECEIVED_WEB_SOCKET_REQUEST_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams response = HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.webSocket, response.sendStream, response.client);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsProxyToResponder implements HttpConnectionDelegate.OnReceivedWebSocketRequestResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(org.chromium.mojo.bindings.InterfaceRequest<WebSocket> webSocket, org.chromium.mojo.system.DataPipe.ConsumerHandle sendStream, WebSocketClient client) {
            HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams _response = new HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams();
            _response.webSocket = webSocket;
            _response.sendStream = sendStream;
            _response.client = client;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    ON_RECEIVED_WEB_SOCKET_REQUEST_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

}

